<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Client extends Model 
{

    protected $table = 'clients';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'd_o_b', 'blood_type_id', 'last_donnation_date', 'city_id', 'phone', 'api_token', 'password');
    protected $hidden = array('api_token');

    public function BloodTypes()
    {
        return $this->belongsToMany('App\Models\BloodType');
    }

    public function notifications()
    {
        return $this->belongsToMany('App\Models\Notification');
    }

    public function posts()
    {
        return $this->belongsToMany('App\Models\Post');
    }

    public function governorates()
    {
        return $this->belongsToMany('App\Models\Governorate');
    }

    public function donnationRequests()
    {
        return $this->hasMany('App\Models\DonnationRequest');
    }

    public function contacts()
    {
        return $this->hasMany('App\Models\Contact');
    }

}